﻿* Encoding: UTF-8.
* Analyse Blue Book mit Jenny.

* Alle Wähler.

GET STATA FILE='/Users/maier/Arbeit/Transfer/Publikationen/2010-2019/2019/Blaues Buch/TV-Duell/Daten/2017/2017_aussage_diff_sig.sav'.

* VARIABLENDEFINITION.
* Sprecher.

compute kandidat=-9.
if (sprech=1) kandidat=1.
if (sprech=2) kandidat=2.
mis val kandidat (-9).

var lab kandidat 'Sprecher'.
val lab kandidat 1 'Merkel' 2 'Schulz' -9 'Moderator, Einspieler etc.'.

compute merkel=-9.
if (sprech=1) merkel=1.
if (sprech=2) merkel=0.
mis val merkel (-9).

var lab merkel 'Sprecher: Merkel'.
val lab merkel 0 'nein' 1 'ja' -9 'kein Kandidatenstatement, da Aussage von Moderator, Einspieler etc.'.


compute schulz=-9.
if (sprech=2) schulz=1.
if (sprech=1) schulz=0.
mis val schulz (-9).

var lab schulz 'Sprecher: Schulz'.
val lab schulz 0 'nein' 1 'ja' -9 'kein Kandidatenstatement, da Aussage von Moderator, Einspieler etc.'.

* Strategie.

compute strategie=-9.
if ((sprech=1 or sprech=2) and strat=2) strategie=1.
if ((sprech=1 or sprech=2) and strat=1) strategie=2.
if ((sprech=1 or sprech=2) and (strat ne 1 and strat ne 2)) strategie=0.
mis val strategie (-9).

var lab strategie 'Strategie'.
val lab strategie 0 'kein/andere Strategie' 1 'Selbstpräsentation (acclaim)' 2 'Angriff (Attack)' -9  'keine Kandidatenstatement, da Aussage von Moderator, Einspieler etc.'.

compute acclaim=-9.
if ((sprech=1 or sprech=2) and strat=2) acclaim=1.
if ((sprech=1 or sprech=2) and strat ne 2) acclaim=0.
mis val acclaim (-9).

var lab acclaim 'Strategie: Selbstpräsentation'.
val lab acclaim 0 'nein' 1 'ja' -9  'kein Kandidatenstatement, da Aussage von Moderator, Einspieler etc.'.

compute attack=-9.
if ((sprech=1 or sprech=2) and strat=1) attack=1.
if ((sprech=1 or sprech=2) and strat ne 1) attack=0.
mis val attack (-9).

var lab attack 'Strategie: Angriff'.
val lab attack 0 'nein' 1 'ja' -9  'kein Kandidatenstatement, da Aussage von Moderator, Einspieler etc.'.

* ANALYSE.
* (1) Deskriptive Informationen für den Methodenteil.
* 4 "Aussagen" aussortieren, in denen nichts gesagt wurde (und für die es entsprechend zwar RTR-Werte gibt, aber keine weiteren Codierungen).

recode sprech (sysmis=-99).
sel if (sprech ne -99).

* Anzahl Gesamtaussagen, Verteilung Aussagen auf Kandidaten und Moderatoren.

fre sprech.

* Anzahl funktionaler und nicht funktionaler Aussagen.

cro tab tocu by sprech.

* nicht-funktionale Ausagen aussortieren.

sel if (tocu=1).

* Dauer der funktionalen Aussagen.

cro tab dauer by sprech.

* Ausagen mit Laufzeit 0 Sekunden aussortieren.

temp.
sel if (dauer gt 0).

* Durchschnittliche Länge der untersuchten Aussagen berechnen.

means tab dauer by kandidat/statistics anova.

* (2) Strategie bestimmen (Tabelle 1).

cro tab strategie by kandidat/cells count col/stat chi.

* (3) Effekt bestimmen (Tabelle 2).
* Alle.

temp.
sel if (strategie ge 1 and dauer gt 0).
means tab diffton0_schulz by strategie/cells mean stdv min max count/statistics anova.

temp.
sel if (strategie ge 1).
means tab diffton1_schulz diffton2_schulz diffton3_schulz diffton4_schulz diffton5_schulz by strategie/cells mean stdv min max count/statistics anova.

* Merkel.

temp.
sel if (kandidat=1 and strategie ge 1 and dauer gt 0).
means tab diffton0_schulz by strategie/cells mean stdv min max count/statistics anova.

temp.
sel if (kandidat=1 and strategie ge 1).
means tab diffton1_schulz diffton2_schulz diffton3_schulz diffton4_schulz diffton5_schulz by strategie/cells mean stdv min max count/statistics anova.

* Schulz.

temp.
sel if (kandidat=2 and strategie ge 1 and dauer gt 0).
means tab diffton0_schulz by strategie/cells mean stdv min max count/statistics anova.

temp.
sel if (kandidat=2 and strategie ge 1).
means tab diffton1_schulz diffton2_schulz diffton3_schulz diffton4_schulz diffton5_schulz by strategie/cells mean stdv min max count/statistics anova.

* Selbstpräsentation.

temp.
sel if (strategie=1 and dauer gt 0).
means tab diffton0_schulz by kandidat/cells mean stdv min max count/statistics anova.

temp.
sel if (strategie=1).
means tab diffton1_schulz diffton2_schulz diffton3_schulz diffton4_schulz diffton5_schulz by kandidat/cells mean stdv min max count/statistics anova.

* Angriff.

temp.
sel if (strategie=2 and dauer gt 0).
means tab diffton0_schulz by kandidat/cells mean stdv min max count/statistics anova.

temp.
sel if (strategie=2).
means tab diffton1_schulz diffton2_schulz diffton3_schulz diffton4_schulz diffton5_schulz by kandidat/cells mean stdv min max count/statistics anova.


* (4) Effektive, ineffektive und kontraproduktive Aussagen (Tabelle 3).
* Klassifikation der Effekte, Effekte mit dichton0_schulz=0 werden auf 0=keine Wirkung gesetzt.

compute effective0=-9.
if (sigdich0=0) effective0=0.
if (sigdich0=1 and diffton0_schulz gt 0) effective0=1.
if (sigdich0=1 and diffton0_schulz lt 0) effective0=-1.
if (diffton0_schulz=0) effective0=0.
mis val effective0 (-9).

var lab effective0 'Effektivität Aussage, Reaktionszeit: 0 Sekunden'.
val lab effective0 -1 'nicht intendierte Wirkung' 0 'keine Wirkung' 1 'intendierte Wirkung'.

compute effective1=-9.
if (sigdich_l1=0) effective1=0.
if (sigdich_l1=1 and diffton1_schulz gt 0) effective1=1.
if (sigdich_l1=1 and diffton1_schulz lt 0) effective1=-1.
if (diffton1_schulz=0) effective1=0.

var lab effective1 'Effektivität Aussage, Reaktionszeit: 1 Sekunde'.
val lab effective1 -1 'nicht intendierte Wirkung' 0 'keine Wirkung' 1 'intendierte Wirkung'.

compute effective2=-9.
if (sigdich_l2=0) effective2=0.
if (sigdich_l2=1 and diffton2_schulz gt 0) effective2=1.
if (sigdich_l2=1 and diffton2_schulz lt 0) effective2=-1.
if (diffton2_schulz=0) effective2=0.

var lab effective2 'Effektivität Aussage, Reaktionszeit: 2 Sekunden'.
val lab effective2 -1 'nicht intendierte Wirkung' 0 'keine Wirkung' 1 'intendierte Wirkung'.

compute effective3=-9.
if (sigdich_l3=0) effective3=0.
if (sigdich_l3=1 and diffton3_schulz gt 0) effective3=1.
if (sigdich_l3=1 and diffton3_schulz lt 0) effective3=-1.
if (diffton3_schulz=0) effective3=0.

var lab effective3 'Effektivität Aussage, Reaktionszeit: 3 Sekunden'.
val lab effective3 -1 'nicht intendierte Wirkung' 0 'keine Wirkung' 1 'intendierte Wirkung'.

compute effective4=-9.
if (sigdich_l4=0) effective4=0.
if (sigdich_l4=1 and diffton4_schulz gt 0) effective4=1.
if (sigdich_l4=1 and diffton4_schulz lt 0) effective4=-1.
if (diffton4_schulz=0) effective4=0.

var lab effective4 'Effektivität Aussage, Reaktionszeit: 4 Sekunden'.
val lab effective4 -1 'nicht intendierte Wirkung' 0 'keine Wirkung' 1 'intendierte Wirkung'.

compute effective5=-9.
if (sigdich_l5=0) effective5=0.
if (sigdich_l5=1 and diffton5_schulz gt 0) effective5=1.
if (sigdich_l5=1 and diffton5_schulz lt 0) effective5=-1.
if (diffton5_schulz=0) effective5=0.

var lab effective5 'Effektivität Aussage, Reaktionszeit: 5 Sekunden'.
val lab effective5 -1 'nicht intendierte Wirkung' 0 'keine Wirkung' 1 'intendierte Wirkung'.
fre effective0 to effective5.

* Alle.

temp.
sel if (strategie ge 1 and dauer gt 0).
cro tab effective0 by strategie/cells count col/stat chi.

temp.
sel if (strategie ge 1).
cro tab effective1 effective2 effective3 effective4 effective5 by strategie/cells count col/stat chi.

* Merkel.

temp.
sel if (kandidat=1 and strategie ge 1).
cro tab effective0 by strategie/cells count col/stat chi.

temp.
sel if (kandidat=1 and strategie ge 1 and dauer gt 0).
cro tab effective1 effective2 effective3 effective4 effective5 by strategie/cells count col/stat chi.

* Schulz.

temp.
sel if (kandidat=2 and strategie ge 1 and dauer gt 0).
cro tab effective0 by strategie/cells count col/stat chi.

temp.
sel if (kandidat=2 and strategie ge 1).
cro tab effective1 effective2 effective3 effective4 effective5 by strategie/cells count col/stat chi.

* Acclaim.

temp.
sel if (strategie=1 and dauer gt 0).
cro tab effective0 by kandidat/cells count col/stat chi.

temp.
sel if (strategie=1).
cro tab effective1 effective2 effective3 effective4 effective5 by kandidat/cells count col/stat chi.

* Angriff.

temp.
sel if (strategie=2 and dauer gt 0).
cro tab effective0 by kandidat/cells count col/stat chi.

temp.
sel if (strategie=2).
cro tab effective1 effective2 effective3 effective4 effective5 by kandidat/cells count col/stat chi.







